/*
 * @(#)Client.java	1.6 03/07/15
 *
 * Copyright (c) 2000-2003 Sun Microsystems, Inc. All rights reserved.
 * PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms
 */
import javax.microedition.midlet.*;
import javax.microedition.io.*;
import javax.microedition.lcdui.*;
import java.io.*;
import java.util.*;

public class Navigator implements Runnable, CommandListener {
    private ShopMIDlet parent;
    private Display display;
    private Form f;
    private StringItem si;
    private boolean stop;
    private Command sendCommand = new Command("Send", Command.ITEM, 1);
    private Command exitCommand = new Command("Exit", Command.EXIT, 1);
    InputStream is;
    OutputStream os;
    SocketConnection sc;
    Sender sender;

    public Navigator(ShopMIDlet m) {
        parent = m;
        display = Display.getDisplay(parent);
        f = new Form("Socket Client");
        si = new StringItem("ө:", " ");
        f.append(si);
        f.addCommand(exitCommand);
        f.addCommand(sendCommand);
        f.setCommandListener(this);
        display.setCurrent(f);
    }

    /**
     * Start the client thread
     */
    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            sc = (SocketConnection) Connector.open("socket://140.117.12.185:8080");
            si.setText("Connected to server");
            is = sc.openInputStream();
            os = sc.openOutputStream();

            // Start the thread for sending messages - see Sender's main
            // comment for explanation
            sender = new Sender(os);
            sender.send("GET /footprint/information.jsp?x=300&y=550 HTTP/1.0\n");

            // Loop forever, receiving data
            while (true)
			   {
                StringBuffer sb = new StringBuffer();
                int c = 0;
                while (((c = is.read()) != '\n') && (c != -1))
				   {
		           if(c == '\t'){c = '\n';};
                   sb.append((char) c);
                   };
                if (c == -1)
                   {
                   break;
                   }
                // Display message to user
                si.setText(sb.toString());
                };
            stop();
            //si.setText("Connection closed");
            f.removeCommand(sendCommand);
           } catch (ConnectionNotFoundException cnfe) {
            Alert a = new Alert("Client", "Please run Server MIDlet first",
                    null, AlertType.ERROR);
            a.setTimeout(Alert.FOREVER);
            a.setCommandListener(this);
            display.setCurrent(a);
        } catch (IOException ioe) {
            if (!stop) {
                ioe.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == sendCommand && !parent.isPaused()) {
            //sender.send(tf.getString());
        }

        if ((c == Alert.DISMISS_COMMAND) || (c == exitCommand)) {
            parent.notifyDestroyed();
            parent.destroyApp(true);
        }
    }

    /**
     * Close all open streams
     */
    public void stop() {
        try {
            stop = true;

            if (sender != null) {
                sender.stop();
            }

            if (is != null) {
                is.close();
            }

            if (os != null) {
                os.close();
            }

            if (sc != null) {
                sc.close();
            }
        } catch (IOException ioe) {}
    }
}
